// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityBug.cpp
// Date           : February 2008
//
// Description    : This file defines the EntityBug class for the user's
//                  controllable avatar.  Once instantiated, the primary
//                  methods for control are Jump(), Run() and Drop().  The
//                  game loop (via CGame) must check IsDead() to determine
//                  if the player has died.
//
// ///////////////////////////////////////////////////////////////////////////
#pragma once



#include "entity.h"
#include "text.h"






class EntityTokenCollector : public Entity 
{

  public:

    int                     m_TokensNeeded;



    EntityTokenCollector();
    ~EntityTokenCollector();


    virtual void            Render( int XOffset, int YOffset );
    virtual void            OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity );

    void                    UpdateTimed( Level& aLevel, float ElapsedTime );

};

